{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 08.01.99 - 12:10:49 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMAVI, MMCstDlg, MMDIB, MMGauge;

type
  TForm1 = class(TForm)
    OpenDialog: TMMAVIOpenDialog;
    AVIFile: TMMAVIFile;
    btnLoad: TButton;
    btnSplit: TButton;
    Gauge: TMMGauge;
    AVICompressor: TMMAVICompressor;
    procedure btnLoadClick(Sender: TObject);
    procedure btnSplitClick(Sender: TObject);
    procedure AVICompressorSave(Sender: TObject; Percent: Integer; var Abort: Boolean);
  private
    Progress: integer;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.btnLoadClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      { close a previous loaded file }
      AVIFile.CloseFile;

      { set the filename }
      AVIFile.FileName := OpenDialog.FileName;

      { open the file }
      AVIFile.OpenFile;

      btnSplit.Enabled := (AVIFIle.StreamCount > 0);
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnSplitClick(Sender: TObject);
var
   VideoStream: TMMAVIStream;
   AudioStream: TMMAVIStream;
   FName: string;

begin
   { get the first video stream }
   VideoStream := AVIFile.TypedStreams[stVideo,0];

   { get the first audio stream }
   AudioStream := AVIFile.TypedStreams[stAudio,0];
   try
      Screen.Cursor  := crHourGlass;

      Progress       := 0;
      Gauge.Progress := 0;
      Gauge.Visible  := True;

      FName := ExtractFilePath(AVIFile.FileName)+ChangeFileExt(ExtractFileName(AVIFile.FileName),'');

      AVICompressor.AddStream(VideoStream);
      AVICompressor.SaveToFile(FName+'_vid.avi');
      AVICompressor.FreeStreams;

      Progress := 50;

      AVICompressor.AddStream(AudioStream);
      AVICompressor.SaveToFile(FName+'_aud.wav');
      AVICompressor.FreeStreams;

      Gauge.Visible  := False;

   finally
      Gauge.Visible := False;
      Screen.Cursor := crDefault;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.AVICompressorSave(Sender: TObject; Percent: Integer; var Abort: Boolean);
begin
   Gauge.Progress := Progress + (Percent div 2);
end;

end.
